"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rootScopedClientRequestWrapper = rootScopedClientRequestWrapper;
var _lodash = require("lodash");
var _utils = require("../../../utils");
/*
 *    Copyright 2021 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function whitelistMap(kibanaVersionIndex) {
  return {
    [`POST/${kibanaVersionIndex}/_search{"size":100,"seq_no_primary_term":true,"from":0,"query":{"bool":{"filter":[{"bool":{"should":[{"match":{"ingest-package-policies.package.name":"endpoint"}}],"minimum_should_match":1}},{"bool":{"should":[{"bool":{"must":[{"term":{"type":"ingest-package-policies"}}],"must_not":[{"exists":{"field":"namespace"}},{"exists":{"field":"namespaces"}}]}}],"minimum_should_match":1}}]}},"sort":[{"ingest-package-policies.updated_at":{"order":"desc","unmapped_type":"date"}}]}`]: true
  };
}
function shouldBeAuthorized(result, kibanaVersionIndex) {
  const {
    method,
    path,
    body
  } = (0, _lodash.get)(result, 'meta.request.params', {});
  let rule = method + path;
  if (body) rule += body;
  return whitelistMap(kibanaVersionIndex)[rule] || false;
}
function rootScopedClientRequestWrapper({
  configService,
  kibanaVersionIndex
}) {
  return (error, result) => {
    if (!(0, _utils.isAuthorized)(result) && shouldBeAuthorized(result, kibanaVersionIndex)) {
      // Authorize as Kibana system user
      const {
        username,
        password
      } = configService.get('elasticsearch', {});
      result.meta.request.params.headers.authorization = `Basic ${Buffer.from(`${username}:${password}`).toString('base64')}`;
    }
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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